/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Rollback
implements Runnable {
    private LinkedBlockingQueue<Edit> edits = new LinkedBlockingQueue();
    PreparedStatement ps = null;
    private Player player;
    private Connection conn = null;

    Rollback(Player player, Connection conn, String name, int minutes, String table) {
        this.player = player;
        this.conn = conn;
        try {
            conn.setAutoCommit(false);
            this.ps = conn.prepareStatement("SELECT type, data, replaced, x, y, z FROM `" + table + "` INNER JOIN `lb-players` USING (`playerid`) WHERE playername = ? AND date > date_sub(now(), INTERVAL ? MINUTE) ORDER BY date DESC", 1);
            this.ps.setString(1, name);
            this.ps.setInt(2, minutes);
        }
        catch (SQLException ex) {
            LogBlock.log.log(Level.SEVERE, String.valueOf(this.getClass().getName()) + " SQL exception", ex);
            player.sendMessage(ChatColor.RED + "Error, check server logs.");
            return;
        }
    }

    Rollback(Player player, Connection conn, String name, int radius, int minutes, String table) {
        this.player = player;
        this.conn = conn;
        try {
            conn.setAutoCommit(false);
            this.ps = conn.prepareStatement("SELECT type, data, replaced, x, y, z FROM `" + table + "` INNER JOIN `lb-players` USING (`playerid`) WHERE playername = ? AND x > ? AND x < ? AND z > ? AND z < ? AND date > date_sub(now(), INTERVAL ? MINUTE) ORDER BY date DESC", 1);
            this.ps.setString(1, name);
            this.ps.setInt(2, player.getLocation().getBlockX() - radius);
            this.ps.setInt(3, player.getLocation().getBlockX() + radius);
            this.ps.setInt(4, player.getLocation().getBlockZ() - radius);
            this.ps.setInt(5, player.getLocation().getBlockZ() + radius);
            this.ps.setInt(6, minutes);
        }
        catch (SQLException ex) {
            LogBlock.log.log(Level.SEVERE, String.valueOf(this.getClass().getName()) + " SQL exception", ex);
            player.sendMessage(ChatColor.RED + "Error, check server logs.");
            return;
        }
    }

    Rollback(Player player, Connection conn, int radius, int minutes, String table) {
        this.player = player;
        this.conn = conn;
        try {
            conn.setAutoCommit(false);
            this.ps = conn.prepareStatement("SELECT type, data, replaced, x, y, z FROM `" + table + "` WHERE x > ? AND x < ? AND z > ? AND z < ? AND date > date_sub(now(), INTERVAL ? MINUTE) ORDER BY date DESC", 1);
            this.ps.setInt(1, player.getLocation().getBlockX() - radius);
            this.ps.setInt(2, player.getLocation().getBlockX() + radius);
            this.ps.setInt(3, player.getLocation().getBlockZ() - radius);
            this.ps.setInt(4, player.getLocation().getBlockZ() + radius);
            this.ps.setInt(5, minutes);
        }
        catch (SQLException ex) {
            LogBlock.log.log(Level.SEVERE, String.valueOf(this.getClass().getName()) + " SQL exception", ex);
            player.sendMessage(ChatColor.RED + "Error, check server logs.");
            return;
        }
    }

    Rollback(Player player, Connection conn, Location loc1, Location loc2, int minutes, String table) {
        this.player = player;
        this.conn = conn;
        try {
            conn.setAutoCommit(false);
            this.ps = conn.prepareStatement("SELECT type, data, replaced, x, y, z FROM `" + table + "` WHERE x >= ? AND x <= ? AND y >= ? AND y <= ? AND z >= ? AND z <= ? AND date > date_sub(now(), INTERVAL ? MINUTE) ORDER BY date DESC", 1);
            this.ps.setInt(1, Math.min(loc1.getBlockX(), loc2.getBlockX()));
            this.ps.setInt(2, Math.max(loc1.getBlockX(), loc2.getBlockX()));
            this.ps.setInt(3, Math.min(loc1.getBlockY(), loc2.getBlockY()));
            this.ps.setInt(4, Math.max(loc1.getBlockY(), loc2.getBlockY()));
            this.ps.setInt(5, Math.min(loc1.getBlockZ(), loc2.getBlockZ()));
            this.ps.setInt(6, Math.max(loc1.getBlockZ(), loc2.getBlockZ()));
            this.ps.setInt(7, minutes);
        }
        catch (SQLException ex) {
            LogBlock.log.log(Level.SEVERE, String.valueOf(this.getClass().getName()) + " SQL exception", ex);
            player.sendMessage(ChatColor.RED + "Error, check server logs.");
            return;
        }
    }

    @Override
    public void run() {
        ResultSet rs = null;
        this.edits.clear();
        try {
            try {
                rs = this.ps.executeQuery();
                while (rs.next()) {
                    Edit e = new Edit(rs.getInt("type"), rs.getInt("replaced"), rs.getByte("data"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), this.player.getWorld());
                    this.edits.offer(e);
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, String.valueOf(this.getClass().getName()) + " SQL exception", ex);
                this.player.sendMessage("\u00a7cError, check server logs.");
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (this.ps != null) {
                        this.ps.close();
                    }
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex2) {
                    LogBlock.log.log(Level.SEVERE, String.valueOf(this.getClass().getName()) + " SQL exception on close", ex2);
                    this.player.sendMessage("\u00a7cError, check server logs.");
                    return;
                }
                return;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, String.valueOf(this.getClass().getName()) + " SQL exception on close", ex);
                this.player.sendMessage("\u00a7cError, check server logs.");
                return;
            }
        }
        int changes = this.edits.size();
        int rolledBack = 0;
        this.player.sendMessage(ChatColor.GREEN + changes + " Changes found.");
        this.player.sendMessage(ChatColor.GOLD + "This may take " + (int)Math.ceil(changes / 1000) + " seconds.");
        int counter = 0;
        Edit e = this.edits.poll();
        while (e != null) {
            if (e.perform()) {
                ++rolledBack;
            }
            if (++counter > 100) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LogBlock.log.log(Level.SEVERE, String.valueOf(this.getClass().getName()) + " SQL exception", ex);
                    this.player.sendMessage("\u00a7cError, check server logs.");
                }
                counter = 0;
            }
            e = this.edits.poll();
        }
        this.player.sendMessage(ChatColor.GREEN + "Rollback finished successfully");
        this.player.sendMessage(ChatColor.GREEN + "Undid " + rolledBack + " of " + changes + " changes");
    }

    private class Edit {
        int type;
        int replaced;
        int x;
        int y;
        int z;
        byte data;
        World world;

        Edit(int type, int replaced, byte data, int x, int y, int z, World world) {
            this.type = type;
            this.replaced = replaced;
            this.data = data;
            this.x = x;
            this.y = y;
            this.z = z;
            this.world = world;
        }

        public boolean perform() {
            if (this.type == this.replaced) {
                return false;
            }
            Block block = this.world.getBlockAt(this.x, this.y, this.z);
            if ((block.getTypeId() == this.type || block.getTypeId() >= 8 && block.getTypeId() <= 11 || block.getTypeId() == 51) && block.setTypeId(this.replaced)) {
                block.setData(this.data);
                return true;
            }
            return false;
        }
    }
}

